# Réalisé par Denis Duplan pour Stash of Code (https://www.stashofcode.fr) en novembre 2021.

# Cette oeuvre est mise à disposition selon les termes de la Licence Creative Commons Attribution - Pas d’Utilisation Commerciale 4.0 International

# Etape 3

# Validation de la signature d'une input d'une transaction. Il s'agit de valider la transaction dont la signature réside dans ScriptSig de l'input 0 de la transaction 1 du bloc 170, qui fait référence à l'ouput 0 de la transaction 0 du bloc 9.

# Je reprends les classes élaborées dans checkBlockchain, je les purge de la vérification par le JSON, j'y rajoute des constructeurs qui ne font que lister les propriétés, et je les loge dans le nouveau package local "btc.objects". Je loge les fonctions comme bytesToString () dans le package "btc.tools". Tant que j'y suis, je n'utilise plus les fichiers de blocs téléchargés, mais je télécharge directement les blocs (ie : downloadBlocks.py n'a plus d'intérêt à ce stade).

from btc.objects import *
from btc.tools import *
import hashlib

path = 'data/'
hash9 = '000000008d9dc510f23c2657fc4f67bea30078cc05a90eb89e84cc475c080805'
hash170 = '00000000d1145790a8694403d4063f323d499e655c83426834d4ce2f8dd4a2ee'
blockchain = Blockchain ()
block9 = blockchain.getBlockByHash (stringToBytes (hash9))
block170 = blockchain.getBlockByHash (stringToBytes (hash170))
tx = block170.transactions[1]
nIn = 0
txIn = tx.inputs[nIn]
nOut = txIn.output
txOut = blockchain.getTransactionByHash (txIn.transaction).outputs[nOut]

# Extraire la signature au format DER

signature = txIn.scriptSig[1:-1]
print (f'Signature: {bytesToString (signature)}')
file = open (f'{path}signature.der', 'wb')
file.write (signature)
file.close ()

# Extraire la clé publique au format DER
# Pour la vérifier avec OpenSSL :
# $ openssl ec -pubin -inform der -in public.der -text -noout

scriptPubKey = txOut.scriptPubKey[1:-1]
x = scriptPubKey[1:1+32]
y = scriptPubKey[1+32:]
scriptPubKey = b'\x04' + x + y
print (f'Public key (x): {bytesToString (x)}')
print (f'Public key (y): {bytesToString (y)}')
publicKey = bytearray ([0x03, len (scriptPubKey) + 1, 0x00]) + scriptPubKey
# OID pour ecPublicKey (https://oidref.com/1.2.840.10045.2.1)
algorithmIdentifierId = b'\x06\x07\x2a\x86\x48\xce\x3d\x02\x01'
# OID pour secp256k1 (https://oidref.com/1.3.132.0.10)
algorithmIdentifierParameters = b'\x06\x05\x2b\x81\x04\x00\x0a'
algorithmIdentifier = algorithmIdentifierId + algorithmIdentifierParameters
publicKey = bytearray ([0x30, len (algorithmIdentifier)]) + algorithmIdentifier + publicKey
publicKey = bytearray ([0x30, len (publicKey)]) + publicKey
file = open (f'{path}public.der', 'wb')
file.write (publicKey)
file.close ()

# Extraire le hash (de type SIGHASH_ALL)
# J'ai implémenté tous les types de hashes en me calant sur SignatureHash() dans script.cpp de la première release de Bitcoin (0.1.0), mais je n'ai testé que SIGHASH_ALL puisque c'est celui utilisé dans la transaction étudiée.

SIGHASH_ALL = 0x00000001
SIGHASH_NONE = 0x00000002
SIGHASH_SINGLE = 0x00000003
SIGHASH_ANYONECANPAY = 0x00000080
hashType = SIGHASH_ALL
if hashType == SIGHASH_ALL:
	pass
elif hashType == SIGHASH_NONE:
	for i in range (len (tx.inputs)):
		if i != nIn:
			tx.inputs[i].sequence = 0
	tx.outputs = []
elif hashType == SIGHASH_SINGLE:
	for i in range (len (tx.inputs)):
		if i != nIn:
			tx.inputs[i].sequence = 0
	tx.outputs = tx.outputs[:nIn + 1]
	for i in range (len (tx.outputs)):
		tx.outputs[i].value = -1
		tx.outputs[i].scriptPubKey = bytearray ()
if hashType & SIGHASH_ANYONECANPAY:
	tx.inputs = [tx.inputs[nIn]]
txIn.scriptSig = txOut.scriptPubKey
# La lecture du code de la première relase (0.1.0) du code montre qu'il faudrait écraser toute occurence de la signature extraite de txIn.scriptSig qui figurerait dans txOut.scriptPubKey. Personne ne semble en mesure d'expliquer comment une signature extraite du ScriptSig de l'input 0 de la transaction 0 du bloc 170 pourrait figurer dans le ScriptPubKey de l'output 0 de la transaction 0 du bloc 9... J'ignore donc royalement cette étape dont je ne comprends pas le sens au-delà de ce cas particulier.
data = tx.serialize ()
data.extend (hashType.to_bytes (4, byteorder='little'))
hash = bytearray (hashlib.sha256 (hashlib.sha256 (data).digest ()).digest ())
print (f'Hash: {bytesToString (hash)}')
file = open (f'{path}hash.bin', 'wb')
file.write (hash)
file.close ()

# Pour vérifier la signature du hash avec la clé publique avec OpenSSL :
# $ openssl pkeyutl -verify -pubin -inkey public.der -keyform der -sigfile signature.der -in hash.bin