# Réalisé par Denis Duplan pour Stash of Code (https://www.stashofcode.fr) en novembre 2021.

# Cette oeuvre est mise à disposition selon les termes de la Licence Creative Commons Attribution - Pas d’Utilisation Commerciale 4.0 International

# Etape 4

# Miner le bloc 170. En fait, je ne vais pas le miner, je vais juste recréer le bloc et vérifier que le hash que j'obtiens correspondant à la réalité.

from btc.objects import *
from btc.tools import *
import hashlib

# Données de base

hash9 = stringToBytes ('000000008d9dc510f23c2657fc4f67bea30078cc05a90eb89e84cc475c080805')
hash170 = stringToBytes ('00000000d1145790a8694403d4063f323d499e655c83426834d4ce2f8dd4a2ee')
blockchain = Blockchain ()
block9 = blockchain.getBlockByHash (hash9)
block170 = blockchain.getBlockByHash (hash170)
hash169 = block170.header.previousBlock
block169 = blockchain.getBlockByHash (hash169)
transaction = block170.transactions[1]

# Le strict nécessaire pour écrire les scripts de la coinbase

OP_CHECKSIG = b'\xac'

def scriptPushBytes (value: bytes) -> bytes:
	if 1 <= len (value) <= 75:
		return bytes (len (value).to_bytes (1, 'little') + value)
	elif len (value) <= 0xff:
		return bytes (b'\x76' + len (value).to_bytes (1, 'little') + value)
	elif len (value) <= 0xffff:
		return bytes (b'\x77' + len (value).to_bytes (2, 'little') + value)
	elif len (value) <= 0xffffffff:
		return bytes (b'\x78' + len (value).to_bytes (4, 'little') + value)
	return None

# Recréer la coinbase. Ce n'est pas exactement ainsi que les choses se dérouleraient s'il fallait miner le bloc, car la valeur de ce qui semble être un extra nonce dans scriptScrig (0x02) ne pourrait évidemment pas être connue pour l'heure. Toutefois, 0x02 correspondait-il bien à un extra nonce quand le bloc 170 a été miné ?

coinbase = Transaction ()
coinbase.version = 1
coinbase.lockTime = 0

txIn = TransactionInput ()
txIn.transaction = bytearray (b'\x00' * 32)
txIn.output = 0xffffffff
txIn.scriptSig = scriptPushBytes (bits.to_bytes (4, 'little')) + scriptPushBytes (b'\x02')
txIn.sequence = 0xffffffff
coinbase.inputs.append (txIn)

txOut = TransactionOutput ()
txOut.value = 50 * 10 ** 8
signature = stringToBytes ('04d46c4968bde02899d2aa0963367c7a6ce34eec332b32e42e5f3407e052d64ac625da6f0718e7b302140434bd725706957c092db53805b821a85b23a7ac61725b')
txOut.scriptPubKey = scriptPushBytes (signature) + OP_CHECKSIG
coinbase.outputs.append (txOut)

# Créer le bloc 170. Ce n'est pas exactement ainsi que les choses se dérouleraient s'il fallait miner le bloc. D'abord la valeur de bits devrait être évaluée et éventuellement corrigée en fonction du rythme de minage des blocs pour maintenir ce dernier à approximativement un bloc toutes les 10 minutes, si je ne me trompe pas. Par ailleurs, car je ne sais pas à quelle étape la date et l'heure sont fixées - il me semble de plus qu'il est convenu de pouvoir jouer dessus pour faciliter la recherche du hash, comme on peut jouer avec l'extra nonce, mais je ne sais pas si c'était un ussage en vigueur à l'époque où le bloc 170 a été miné.

block = Block ()
block.transactions.append (coinbase)
block.transactions.append (transaction)
block.header.version = 1
block.header.previousBlock = hash169
block.header.merkleTreeRoot = block.hashTransactions ()
block.header.time = datetime.datetime.strptime ('2009-01-12 03:30:25', '%Y-%m-%d %H:%M:%S')
block.header.bits = 0x1d00ffff
block.header.nonce = 0

# Test : vérifier que le hash serait bon avec le nonce final connnu à l'avance

# Le merkle tree root est stocké en big endian ??? car quand je demande l'hex je tombe sur celui que j'ai calculé :
# 	https://blockchain.info/rawblock/00000000d1145790a8694403d4063f323d499e655c83426834d4ce2f8dd4a2ee?format=hex
# 	FF 10 4C CB 05 42 1A B9 3E 63 F8 C3 CE 5C 2C 2E 9D BB 37 DE 27 64 B3 A3 17 5C 81 66 56 2C AC 7D
# mais dans le json qu'il me sort, il renverse l'ordre des octets?:
# 	https://blockchain.info/rawblock/00000000d1145790a8694403d4063f323d499e655c83426834d4ce2f8dd4a2ee
# 	mrkl_root	"7dac2c5666815c17a3b36427de37bb9d2e2c5ccec3f8633eb91a4205cb4c10ff"
# Pour prendre un autre hash, celui du bloc précédent dans le header. Dans le hex qu'il retourne pour le bloc 171, je trouve donc le hash du bloc 170 que je suis en train de miner :
# 	https://blockchain.info/rawblock/00000000c9ec538cab7f38ef9c67a95742f56ab07b0a37c5be6b02808dbfb4e0?format=hex
# 	EE A2 D4 8D 2F CE D4 34 68 42 83 5C 65 9E 49 3D 32 3F 06 D4 03 44 69 A8 90 57 14 D1 00 00 00 00
# Et celui que je calcule c'est :
# 	EE A2 D4 8D 2F CE D4 34 68 42 83 5C 65 9E 49 3D 32 3F 06 D4 03 44 69 A8 90 57 14 D1 00 00 00 00
# Bref les hashes que je calcule sont ceux que je retrouve dans l'hex, alors est-ce que je les calcule en little endian ? C'est peut-être le cas, car je lis ici :
# 	https://en.bitcoin.it/wiki/Block_hashing_algorithm
# 	"The hash, which is a 256-bit number, has lots of leading zero bytes when stored or printed as a big-endian hexadecimal constant, but it has trailing zero bytes when stored or printed in little-endian"
# Comme les hashes que je calcule ont des trailings 0, c'est qu'il sont en LE ?
block.header.merkleTreeRoot.reverse ()
block.header.nonce = 1889418792
print (block.dump ())
print (bytesToString (block.serialize ()))
hash = block.hashHeader ()
if hash == block170.hashHeader ():
	print ('OK')
else:
	print ('NOK')
quit ()

# A FAIRE : Miner le block
# Récupérer la difficulté dans le header du bloc 169 et l'ajuster en fonction du temps écoulé et autres critères pour limiter la génération à 10 min. Le code qui suit n'a peut-être rien à voir avec ce qu'il faut faire, c'est juste pour se donner une base de réflexion.
# bits = 0x1d00ffff
# target = bits * 2 ** (8 * (0x1b - 3))
# while True:
# 	hash = block.hashHeader ()
# 	hash.reverse ()
# 	print (f'\rNonce {block.header.nonce:04x}: {bytesToString (hash)}', end='')
# 	if hash <= target:
# 		break
# print (f'Hash: {hash}')
