# Réalisé par Denis Duplan pour Stash of Code (https://www.stashofcode.fr) en novembre 2021.

# Cette oeuvre est mise à disposition selon les termes de la Licence Creative Commons Attribution - Pas d’Utilisation Commerciale 4.0 International

# Etape 1

# Téléchargement de N blocs consécutifs de la blockchain BTC via un site qui permet de récupérer un bloc au format JSON et HEX à partir de son hash. On génère un fichier qui reprend le JSON auquel on rajoute pour chaque bloc une clé "hex" avec le HEX.

# Pour plus d'informations sur le site : https://www.blockchain.com/api/blockchain_api

# Noter que le JSON ne doit pas être considéré comme une extraction brute de la blockchain au même titre que le HEX : c'est le produit de tout un traitement effectué par le site. Par exemple, les données brutes d'un bloc N ne contiennent naturellement pas le hash du bloc N+1, ce bloc N+1 n'existant pas quand le bloc N a été créé. Toutefois, le JSON du bloc N contient une clé "next_block" dont la valeur est le hash du bloc N+1...

import requests
import json

url = 'https://blockchain.info/rawblock/'
# Quelques blocs pouvant servir de points de départ pour des tests...
# Le premier bloc
blockGenesis = { 'n': 0, 'hash': '000000000019d6689c085ae165831e934ff763ae46a2a6c172b3f1b60a8ce26f' }
# Le premier bloc contenant une transaction dont une input fait référence à une output d'une transaction antérieure
block170 = { 'n': 170, 'hash': '00000000d1145790a8694403d4063f323d499e655c83426834d4ce2f8dd4a2ee' }
# Le dernier bloc avant SegWit (1696 transactions)
block481823 = { 'n': 481823, 'hash': '000000000000000000cbeff0b533f8e1189cf09dfbebf57a8ebe349362811b80' }
# Le premier bloc avec SegWit (1866 transactions)
block481824 = { 'n': 481824, 'hash': '0000000000000000001c8018d9cb3b742ef25114f27563e3fc4a1902167f9893' }
# Le dernier bloc en date au moment où j'écris ce code (2489 transactions)
block709703 = { 'n': 709703, 'hash': '000000000000000000090113b01c84ea4ed0530ead45d74e415cfebb6cff1fd6' }
path = 'data/'

def getBlocks (firstBlock, n):
	blocks = []
	hash = firstBlock['hash']
	start = firstBlock['n']
	for i in range (start, start + n):
		print (f'\rDownloading block {i} to {start + n - 1}: {hash}', end='')
		block = getBlock (hash)
		# Recherche de SegWit (utilisé pour trouver le premier block avec SegWit)
		# for transaction in block['tx']:
		# 	for txin in transaction['inputs']:
		# 		if txin['witness'] != '':
		# 			print (f'\nfound at {i}: {txin["witness"]}')
		# 			quit ()
		blocks.append (block)
		hash = block['next_block'][0]
	print ('\nDone downloading')
	return blocks

def getBlock (hash):
	response = requests.get (f'{url}{hash}?format=json')
	block = json.loads (response.content.decode ('utf-8'))
	response = requests.get (f'{url}{hash}?format=hex')
	block['hex'] = response.content.decode ('utf-8')
	if response.status_code != 200:
		raise Exception (f'Error: HTTP code {response.status_code}')
	return block

try:
	block = blockGenesis
	n = 171
	print (f'Downloading {n} blocks starting from block {block["n"]} ({block["hash"]})')
	blocks = getBlocks (block, n)
	if n == 1:
		filename = f'{block["n"]:06d}'
	else:
		filename = f'{block["n"]:06d}-{block["n"] + n - 1:06d}'
	print (f'Writing to file "{path}{filename}.json"')
	file = open (f'{path}{filename}.json', 'wt')
	file.write (json.dumps (blocks, indent='\t'))
	file.close ()
	print (f'Done')
except Exception as e:
	print (f'Error: {e}')